<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Firebase projects with database URLs and Database Secrets
    $firebaseProjects = [
        [
            'databaseUrl' => 'https://islamicapps-storage6-1-default-rtdb.firebaseio.com',
            'databaseSecret' => 'pvkeys/islamicapps_storage6/islamicapps-storage6-1.json', // Replace with actual secret
        ],
        [
            'databaseUrl' => 'https://islamicapps-storage6-2-default-rtdb.firebaseio.com',
            'databaseSecret' => 'pvkeys/islamicapps_storage6/islamicapps-storage6-2.json', // Replace with actual secret
        ],
        // Add more projects as needed
    ];

    // Data path to process
    $dataPath = 'notifications/bangla';

    // Function to fetch data from Firebase
    function fetchFirebaseData($url, $secret, $dataPath) {
        $fetchUrl = $url . '/' . $dataPath . '.json?auth=' . $secret;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $fetchUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'CURL Error: ' . curl_error($ch) . PHP_EOL;
            return null;
        }

        curl_close($ch);

        return json_decode($response, true);
    }

    // Function to delete data from Firebase
    function deleteFirebaseData($url, $secret, $dataPath) {
        $deleteUrl = $url . '/' . $dataPath . '.json?auth=' . $secret;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $deleteUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
            echo 'CURL Error: ' . curl_error($ch) . PHP_EOL;
        } elseif ($httpCode === 200) {
            echo "Successfully deleted: $dataPath" . PHP_EOL;
        } else {
            echo "Failed to delete: $dataPath. HTTP Code: $httpCode. Response: $response" . PHP_EOL;
        }

        curl_close($ch);
    }

    // Process each Firebase project
    foreach ($firebaseProjects as $project) {
        $data = fetchFirebaseData($project['databaseUrl'], $project['databaseSecret'], $dataPath);

        if ($data === null) {
            echo "Failed to fetch data from: " . $project['databaseUrl'] . PHP_EOL;
            continue;
        }

        ksort($data); // Sort data by keys (or timestamps)

        // Get keys to delete (all except the last 50)
        $keysToDelete = array_slice(array_keys($data), 0, -10);

        foreach ($keysToDelete as $key) {
            deleteFirebaseData($project['databaseUrl'], $project['databaseSecret'], $dataPath . '/' . $key);
        }

        echo "Data cleanup completed for project: " . $project['databaseUrl'] . PHP_EOL;
    }

    // Redirect back to the HTML file with a success flag
    header("Location: index.html?success=true");
    exit;
}
?>
