<?php
// Array of Firebase projects with database URLs and Database Secrets
$firebaseProjects = [
    [
        'databaseUrl' => 'https://islamicapps-storage6-1-default-rtdb.firebaseio.com',
        'databaseSecret' => 'pvkeys/islamicapps_storage6/islamicapps-storage6-1.json', // Replace with actual secret
    ],
    [
        'databaseUrl' => 'https://islamicapps-storage6-2-default-rtdb.firebaseio.com',
        'databaseSecret' => 'pvkeys/islamicapps_storage6/islamicapps-storage6-2.json', // Replace with actual secret
    ],
    // Add more projects as needed
];

// Data path to delete (e.g., 'users/data-to-delete')
$dataPath = 'notifications/bangla';

// Function to send DELETE request
function deleteFirebaseData($url, $secret, $dataPath)
{
    $deleteUrl = $url . '/' . $dataPath . '.json?auth=' . $secret;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $deleteUrl);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        echo 'CURL Error: ' . curl_error($ch) . PHP_EOL;
    } elseif ($httpCode === 200) {
        echo "Successfully deleted data from: $deleteUrl" . PHP_EOL;
    } else {
        echo "Failed to delete data from: $deleteUrl. HTTP Code: $httpCode. Response: $response" . PHP_EOL;
    }

    curl_close($ch);
}

// Loop through each Firebase project and delete data
foreach ($firebaseProjects as $project) {
    echo "Processing project: " . $project['databaseUrl'] . PHP_EOL;
    deleteFirebaseData($project['databaseUrl'], $project['databaseSecret'], $dataPath);
}
