<?php
// Firebase projects with database URLs and Database Secrets
$firebaseProjects = [
        [
            'databaseUrl' => 'https://islamicapps-storage6-1-default-rtdb.firebaseio.com',
            'databaseSecret' => 'pvkeys/islamicapps_storage6/islamicapps-storage6-1.json', // Replace with actual secret
        ],
        [
            'databaseUrl' => 'https://islamicapps-storage6-2-default-rtdb.firebaseio.com',
            'databaseSecret' => 'pvkeys/islamicapps_storage6/islamicapps-storage6-2.json', // Replace with actual secret
        ],
        // Add more projects as needed
];

// Function to fetch data from Firebase
function fetchFirebaseData($url, $secret)
{
    $fetchUrl = $url . '.json?auth=' . $secret;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $fetchUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return null;
    }

    curl_close($ch);

    return json_decode($response, true);
}

header('Content-Type: application/json');

$report = [];

foreach ($firebaseProjects as $project) {
    $data = fetchFirebaseData($project['databaseUrl'], $project['databaseSecret']);

    if ($data === null) {
        continue;
    }

    $dataCount = count($data);
    $report[] = [
        'name' => $project['name'],
        'dataCount' => $dataCount,
    ];
}

echo json_encode($report);
