<?php

// Firebase configuration
$projectId = 'islamic-apps---iasi-10'; // Replace with your Firebase Project ID

// Helper function to save app details to Firebase Realtime Database
function saveAppToFirebase($projectId, $title, $description, $iconUrl, $featureImageUrl, $apkUrl, $screenshotsUrls, $versionCode, $dateTime, $category) {
    // Firebase Realtime Database URL
    $firebaseUrl = "https://$projectId-default-rtdb.firebaseio.com/apps.json";

    // Prepare app data
    $data = [
        'title' => $title,
        'description' => $description,
        'icon_url' => $iconUrl,
        'feature_image_url' => $featureImageUrl,
        'apk_url' => $apkUrl,
        'screenshots_urls' => explode(',', $screenshotsUrls),  // Split comma-separated URLs into an array
        'version_code' => $versionCode,
        'upload_date_time' => $dateTime,
        'category' => $category,
        'timestamp' => time()
    ];

    // Make POST request to Firebase
    $options = [
        'http' => [
            'method'  => 'POST',
            'header'  => "Content-Type: application/json\r\n",
            'content' => json_encode($data)
        ]
    ];

    $context = stream_context_create($options);
    $response = file_get_contents($firebaseUrl, false, $context);

    if ($response === false) {
        return "Failed to save app details to Firebase.";
    } else {
        return "App details saved successfully!";
    }
}

// Process form data
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form data
    $title = $_POST['title'];
    $description = $_POST['description'];
    $iconUrl = $_POST['icon_url'];
    $featureImageUrl = $_POST['feature_image_url'];
    $apkUrl = $_POST['apk_url'];
    $screenshotsUrls = $_POST['screenshots_url'];
    $versionCode = $_POST['version_code'];
    $dateTime = $_POST['date_time'];
    $category = $_POST['category'];

    // Validate required fields
    if (empty($title) || empty($description) || empty($iconUrl) || empty($apkUrl) || empty($versionCode) || empty($dateTime) || empty($category)) {
        echo "Please fill in all the required fields.";
        exit;
    }

    // Save app details to Firebase
    $saveResponse = saveAppToFirebase($projectId, $title, $description, $iconUrl, $featureImageUrl, $apkUrl, $screenshotsUrls, $versionCode, $dateTime, $category);

    // Output the result
    echo $saveResponse;
}

?>
